this.name        = "ups_parcel"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "Parcel missions of UPS Courier"; 
this.version     = "1.3.1"; 


this.startUp = function()
{
    if (oolite.compareVersion("1.70") > 0)
    {
        // Oolite version is older than 1.70.
        LogWithClass("script."+this.name, "This UPS-Courier missions does not run under Oolite version " + oolite.versionString + " Parcel missions are disabled.")
        delete this.missionScreenEnded
        delete this.shipExitedWitchspace
        delete this.shipDockedWithStation
    }
}

this.shipDockedWithStation = function()
{
        this.ups_missionoffers()
}

this.missionScreen=function(messageKey, backGround, choiceKey)
{
        mission.showShipModel();mission.setMusic()
	mission.setBackgroundImage(backGround);
	mission.showMissionScreen();
	mission.addMessageTextKey(messageKey);
        if (choiceKey != null) mission.setChoicesKey(choiceKey)
}

this.ups_missionoffers = function()
{
    if (player.dockedStation.isMainStation && !missionVariables.offering && guiScreen != "GUI_SCREEN_MISSION")
    {
        if (missionVariables.ups_parcel == "YES")
        {
            if (system.government == 4 && missionVariables.ups_dcount > 2 && player.bounty < 3 && !mission.choice)
            {
                missionVariables.ups_parcel_appearance = ExpandDescription("[ups_numbers]") + " " + ExpandDescription("[ups_colors]") + " " + ExpandDescription("[%I]")
                if (missionVariables.ups_pcount == 0)
                {this.missionScreen("ups_parcel_1st_offer", "UPS.png", "ups_parcel_accepted_yesno")}
                else {this.missionScreen("ups_parcel_offer", "UPS.png", "ups_parcel_accepted_yesno")}
                missionVariables.offering ="UPS_PARCELS"
            }
        }
        if(missionVariables.ups_parcel == "SMALL_DELIVERY")
        {
            if(system.government == 4)
            {
                if(missionVariables.ups_pplanet == system.ID)
                {
                    this.missionScreen("ups_back_at_home", "UPS.png", null)
                    missionVariables.ups_parcel = "ACCEPTED"
                }
                else
                {
                    missionVariables.ups_parcel = "NOT_NOW"
                    player.credits += 150
                    mission.setInstructionsKey()
                    if (missionVariables.ups_pcount == 0) {this.missionScreen("ups_parcel_1st_unloading", "UPS.png", null)}
                    else
                    {
                        if(missionVariables.ups_ambush == "YES")
                        {
                            this.missionScreen("ups_parcel_ambush", "UPS.png", null)
                            player.credits += 500
                        }
                        else
                        {
                            this.missionScreen("ups_parcel_unloading", null, null)
                        }
                    }
                    missionVariables.ups_pcount++
                    player.call("increaseContractReputation")
                    missionVariables.ups_parcel_appearance = null 
                    missionVariables.ups_ambush = null 
                    missionVariables.ups_pplanetname = null
                }
            }
        }
        if (missionVariables.ups_parcel == "LOGGING")
        {
            if(system.government == 4 && player.credits > 15000 && missionVariables.ups_pplanet != system.ID && missionVariables.ups_ptimerstart < (clock.days - 8) && !mission.choice)
            {
                missionVariables.ups_museumGoods = ExpandDescription("[ups_museumGoods]")
                if(!missionVariables.ups_trumbles && missionVariables.trumbles == "TRUMBLE_BOUGHT" && Math.random() < 0.25)
                {
                    if(player.hasEquipment("EQ_TRUMBLE")){player.removeEquipment("EQ_TRUMBLE")}
                    missionVariables.ups_museumGoods = ExpandDescription("[ups_trumbles]")
                    missionVariables.ups_trumbles = "ESCAPED"
                }
                this.missionScreen("ups_parcel_offer2", "UPS.png", "ups_parcel_accepted_yesno")
                missionVariables.offering = "UPS_PARCELS2"
            }
        }
        if (missionVariables.ups_parcel == "SPECIAL_DELIVERY")
        {
            if(system.government == 4 && missionVariables.ups_pplanet == system.ID)
            {
                if(missionVariables.ups_trumbles == "ESCAPED")
                {
                    this.missionScreen("ups_parcel_trumbles", "trumblebox.png", null)
                    player.credits -= 1000
                    missionVariables.ups_trumbles = "YES"
                }
                else
                {
                    this.missionScreen("ups_parcel_unloading2", "UPS.png", null)
                    
                }
                player.credits += 15000
                missionVariables.ups_pcount++
                mission.setInstructionsKey()
                missionVariables.ups_parcel = "NOT_NOW"
                missionVariables.ups_pplanetname = null
                missionVariables.ups_museumGoods = null
                missionVariables.ups_escorts = null 
//              mission.unmarkSystem(missionVariables.ups_pplanet) // this command crashes Oolite 1.70!
                player.call("removeMissionDestination:", missionVariables.ups_pplanet)
                missionVariables.ups_ptimerstart = null 
                player.call("increaseContractReputation")
            }
        }
        if (missionVariables.ups_parcel == "MIDAIR_DELIVERY" && missionVariables.ups_pplanet == system.ID)
        {
                this.missionScreen("ups_parcel_unloading", null, null)
                player.credits += 150
                missionVariables.ups_pcount++
                mission.setInstructionsKey() 
                missionVariables.ups_parcel = "NOT_NOW"
//               mission.unmarkSystem(missionVariables.ups_pplanet) // this command crashes Oolite 1.70!
                player.call("removeMissionDestination:", missionVariables.ups_pplanet)
                missionVariables.ups_pplanetname = null
        }
    }
}

this.missionScreenEnded = function()
{
    if (missionVariables.offering == "UPS_PARCELS")
    {
        if(mission.choice == "YESParcel")
        {
            mission.clearMissionScreen() 
            mission.resetMissionChoice()
            mission.setInstructionsKey("ups_parcel_small") 
            missionVariables.ups_parcel = "ACCEPTED" 
            missionVariables.offering = null
            missionVariables.ups_pplanet = system.ID 
            missionVariables.ups_pplanetname = ExpandDescription("[%H]")
            if (Math.random() < 0.2 && missionVariables.ups_pcount > 1) {missionVariables.ups_ambush = "POSSIBLE"}
        }
        else
        {
            if (mission.choice == "NOParcel")
            {
                mission.clearMissionScreen() 
                mission.resetMissionChoice()
                missionVariables.ups_parcel = "NOT_NOW" 
                missionVariables.offering = null
                missionVariables.ups_parcel_appearance = null
                if (Math.random() < 0.3){player.call("decreaseContractReputation")}
            }
        }
    }
    if (missionVariables.offering == "UPS_PARCELS2")
    {
        if(mission.choice == "YESParcel")
        {
            mission.clearMissionScreen() 
            mission.resetMissionChoice()
            mission.setInstructionsKey("ups_parcel_small2") 
            missionVariables.ups_parcel = "SPECIAL_DELIVERY" 
            missionVariables.offering = null
            mission.markSystem(missionVariables.ups_pplanet) 
            player.credits -= 10000
            missionVariables.ups_escorts = 8
        }
        else
        {
            if (mission.choice == "NOParcel")
            {
                mission.clearMissionScreen() 
                mission.resetMissionChoice()
                missionVariables.ups_parcel = "NOT_NOW" 
                missionVariables.offering = null
            }
        }
    }
    this.ups_missionoffers()
}

this.shipExitedWitchspace = function()
{
    if(missionVariables.ups_parcel == "NOT_NOW" && Math.random() < 0.1){missionVariables.ups_parcel = "NO"}
    if(missionVariables.ups_parcel == "NO")
    {
        if(missionVariables.ups_parcel == "NO" && Math.random() < 0.2 && system.government == 4)
        {missionVariables.ups_parcel = "YES"}
        if(missionVariables.ups_parcel == "NO" && Math.random() < 0.05 && system.government == 4 && player.credits > 15000 && !system.goneNova && missionVariables.ups_pcount > 5)
        {
            missionVariables.ups_parcel = "LOGGING"
            missionVariables.ups_pplanet = system.ID
            missionVariables.ups_pplanetname = ExpandDescription("[%H]")
            missionVariables.ups_ptimerstart = clock.days
        }
        if(missionVariables.ups_parcel == "NO" && Math.random() < 0.1 && system.government > 3 && system.ecomomy > 3 && missionVariables.ups_tcount > 1)
        {let position = Math.random()*0.8+0.1; system.legacy_addSystemShips("derelict2_ptt", 1, position)}
        if(missionVariables.ups_parcel == "NO" && missionVariables.ups_trumbles == "YES")
        {
            player.awardEquipment("EQ_TRUMBLE")
            missionVariables.ups_trumbles = "INFECTED"
        }
    }
    else
    {
        let chance = 0
        if(missionVariables.ups_parcel == "ACCEPTED"){missionVariables.ups_parcel = "SMALL_DELIVERY"}
        if(missionVariables.ups_parcel == "SMALL_DELIVERY" && system.ID > -1)
        {
            system.legacy_addSystemShips("ups_pirate", 3, 0.33)
            if(Math.random() < 0.1 && missionVariables.ups_ambush == "POSSIBLE")
            {missionVariables.ups_ambush = "YES";player.consoleMessage("Ambush, you are spotted.", 6)}
        }
        if(missionVariables.ups_ambush == "YES" && Math.random() < 0.5 && system.ID > -1)
        {
            system.legacy_addShips("ups_pirate", 1)
            system.legacy_addSystemShips("ups_pirate", 2, 0.2)
            if(player.score > 1000 && (Math.random()*100 + missionVariables.ups_pcount - 2*system.government) > 70)
            {
                system.legacy_addShips("ups_pirate", 3)
                chance = Math.random()
                system.legacy_addSystemShips("ups_pirate", 3, chance)
                chance = Math.random()
                system.legacy_addSystemShips("ups_pirate_leader", 1, chance)
            }
            if(player.score > 2500 && (Math.random()*100 + missionVariables.ups_pcount - 2*system.government) > 70)
            {
                system.legacy_addShips("ups_pirate", 3)
                chance = Math.random()
                system.legacy_addSystemShips("ups_pirate", 3, chance)
                chance = Math.random()
                system.legacy_addSystemShips("ups_pirate_leader", 1, chance)
            }
        }
        if(missionVariables.ups_parcel == "SPECIAL_DELIVERY" && system.ID > -1)
        {
            let escortnumber = missionVariables.ups_escorts
            system.legacy_addShips("escort_ups", escortnumber)
            if(Math.random() < 0.5)
            {
                 system.legacy_addSystemShips("ups_pirate", 4, 0.05)
                 system.legacy_addSystemShips("ups_pirate", 3, 0.075)
                 system.legacy_addSystemShips("ups_pirate", 3, 0.10)
                 system.legacy_addSystemShips("ups_pirate", 2, 0.125)
                 system.legacy_addSystemShips("ups_pirate", 1, 0.15)
            }
            chance = Math.random()
            system.legacy_addSystemShips("ups_pirate", 5, chance)
        }
    }
    if(missionVariables.ups_parcelreset == "YES")
    {
        if(missionVariables.ups_parcel == "LOGGING" || missionVariables.ups_parcel == "SPECIAL_DELIVERY")
        {
             missionVariables.ups_pplanetname = null
             mission.setInstructionsKey()
//           mission.unmarkSystem(missionVariables.ups_pplanet) // this command crashes Oolite 1.70!
             player.call("removeMissionDestination:", missionVariables.ups_pplanet)
             missionVariables.ups_pplanet = null
             missionVariables.ups_parcel = "NOT_NOW" 
             missionVariables.ups_ptimerstart = null
        }
    missionVariables.ups_parcelreset = null
    if(!player.hasEquipment("EQ_TRUMBLE")){missionVariables.ups_trumbles = null}
    }
}

this.tickle = function(status)
{
    if(status = "STATUS_IN_FLIGHT" && missionVariables.ups_parcel == "MIDAIR")
    {
         missionVariables.ups_parcel = "MIDAIR_DELIVERY" 
         missionVariables.ups_pplanetname = ExpandDescription("[%H]") 
         missionVariables.ups_pplanet = system.ID
         mission.setInstructionsKey("ups_parcel_midair")
         mission.markSystem(system.ID)
         missionVariables.ups_parcel_appearance = ExpandDescription("[ups_numbers]") + " " + ExpandDescription("[ups_colors]") + " " + ExpandDescription("[%I]")
    }
}